// Chat Widget JavaScript
document.addEventListener('DOMContentLoaded', function() {
    const chatbot = document.getElementById('ace-chatbot');
    const toggle = document.getElementById('ace-chatbot-toggle');
    const closeBtn = document.getElementById('ace-chatbot-close');
    const input = document.getElementById('ace-chatbot-input');
    const sendBtn = document.getElementById('ace-chatbot-send');
    const messagesContainer = document.getElementById('ace-chatbot-messages');

    if (!toggle || !chatbot) return;

    // Toggle chatbot visibility
    toggle.addEventListener('click', function() {
        chatbot.classList.toggle('d-none');
        if (!chatbot.classList.contains('d-none')) {
            input?.focus();
        }
    });

    // Close chatbot
    if (closeBtn) {
        closeBtn.addEventListener('click', function() {
            chatbot.classList.add('d-none');
        });
    }

    // Send message function
    function sendMessage() {
        if (!input || !messagesContainer) return;

        const message = input.value.trim();
        if (!message) return;

        // Add user message
        addMessage(message, 'user');
        input.value = '';

        // Simulate bot response
        setTimeout(() => {
            const responses = [
                "Hello! How can I help you with your lead generation today?",
                "I'm here to assist you with the Google Maps scraper. What would you like to know?",
                "Feel free to ask me about the scraping process or any other features!",
                "I can help you understand how to use the LeadSniper tool effectively."
            ];
            const randomResponse = responses[Math.floor(Math.random() * responses.length)];
            addMessage(randomResponse, 'bot');
        }, 1000);
    }

    // Add message to chat
    function addMessage(text, sender) {
        const messageDiv = document.createElement('div');
        messageDiv.className = `chat-message ${sender}`;
        messageDiv.textContent = text;
        messagesContainer.appendChild(messageDiv);
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    }

    // Event listeners
    if (sendBtn) {
        sendBtn.addEventListener('click', sendMessage);
    }

    if (input) {
        input.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                sendMessage();
            }
        });
    }

    // Initialize with welcome message
    if (messagesContainer) {
        addMessage("Hello! I'm your Social Link Scraper assistant. How can I help you today?", 'bot');
    }
});

// Export for global access
window.aceChatbot = {
    toggle: function() {
        const chatbot = document.getElementById('ace-chatbot');
        if (chatbot) {
            chatbot.classList.toggle('d-none');
        }
    },
    show: function() {
        const chatbot = document.getElementById('ace-chatbot');
        if (chatbot) {
            chatbot.classList.remove('d-none');
        }
    },
    hide: function() {
        const chatbot = document.getElementById('ace-chatbot');
        if (chatbot) {
            chatbot.classList.add('d-none');
        }
    }
};
