// Test data for debugging
const testData = [
  {
    name: "Test Restaurant 1",
    phone: "+1 (555) 123-4567",
    category: "Restaurant",
    address: "123 Main St, New York, NY 10001",
    website: "https://test1.com",
    totalReviews: 150,
    rating: "4.5",
    whatsapp: true,
    hasDescription: true,
    galleryPhotoCount: 10,
    galleryPhotoCountLabel: "More than 10",
    hours: "9:00 AM - 10:00 PM",
    ownerReplyCount: 25,
    hasQA: true,
    hasProducts: false,
    activeBusiness: true,
    placeId: "ChIJTest1",
    _keyword: "test"
  },
  {
    name: "Test Restaurant 2",
    phone: "+1 (555) 987-6543",
    category: "Restaurant",
    address: "456 Oak Ave, Los Angeles, CA 90210",
    website: "https://test2.com",
    totalReviews: 200,
    rating: "4.8",
    whatsapp: false,
    hasDescription: true,
    galleryPhotoCount: 7,
    galleryPhotoCountLabel: "Less than 10",
    hours: "8:00 AM - 11:00 PM",
    ownerReplyCount: 40,
    hasQA: true,
    hasProducts: true,
    activeBusiness: true,
    placeId: "ChIJTest2",
    _keyword: "test"
  }
];

// Function to manually test data injection
function injectTestData() {
  console.log("[TEST] Injecting test data...");

  // Simulate the message that should come from the extension
  window.postMessage({
    type: "EXT_SCRAPER_RESPONSE",
    tool: "mapsScraper",
    queue: "test",
    stream: true,
    results: testData,
    total: testData.length
  }, "*");

  console.log("[TEST] Test data injected");
}

// Function to test table directly
function testTableDirectly() {
  console.log("[TEST] Testing table directly...");

  const tbody = document.getElementById("resultsTable");
  if (!tbody) {
    console.error("[TEST] Table tbody not found!");
    return;
  }

  // Add a simple test row
  const testRow = document.createElement("tr");
  testRow.innerHTML = `
    <td>Test Business</td>
    <td>+1 (555) 123-4567</td>
    <td>Test Category</td>
    <td>123 Test St</td>
    <td>https://test.com</td>
    <td>4.5</td>
    <td>100</td>
  `;

  tbody.appendChild(testRow);
  console.log("[TEST] Test row added to table");
}

// Function to test counters directly
function testCounters() {
  console.log("[TEST] Testing counters directly...");

  // Check if counter elements exist
  const profilesCount = document.getElementById("profilesCount");
  const visitedCount = document.getElementById("visitedCount");
  const skippedCount = document.getElementById("skippedCount");

  console.log("[TEST] Counter elements found:", {
    profilesCount: !!profilesCount,
    visitedCount: !!visitedCount,
    skippedCount: !!skippedCount
  });

  // Test updating counters
  if (profilesCount) {
    profilesCount.textContent = "5";
    console.log("[TEST] Set profilesCount to 5");
  }
  if (visitedCount) {
    visitedCount.textContent = "10";
    console.log("[TEST] Set visitedCount to 10");
  }
  if (skippedCount) {
    skippedCount.textContent = "3";
    console.log("[TEST] Set skippedCount to 3");
  }

  // Test incrementing
  setTimeout(() => {
    if (profilesCount) {
      const current = parseInt(profilesCount.textContent) || 0;
      profilesCount.textContent = String(current + 1);
      console.log("[TEST] Incremented profilesCount to:", profilesCount.textContent);
    }
  }, 1000);
}

// Make functions available globally
window.testHelpers = {
  injectTestData,
  testTableDirectly,
  testCounters,
  testData
};

console.log("[TEST] Test helpers loaded. Use window.testHelpers.injectTestData() to test");
